void setup() {
  pinMode(2, OUTPUT);
  pinMode(3, OUTPUT);
  pinMode(4, OUTPUT);
  pinMode(5, OUTPUT);
  pinMode(6, OUTPUT);
  pinMode(7, OUTPUT);
  pinMode(8, OUTPUT);
  pinMode(9, OUTPUT);
  pinMode(10, OUTPUT);
  pinMode(11, OUTPUT);
  pinMode(14, OUTPUT);
  pinMode(15, OUTPUT);
  Serial.begin(9600);
}

// IN1: H, IN2: L, PWM: H
void left_motor_a_cw(int speed) {
  digitalWrite(15, HIGH);
  digitalWrite(3, LOW);
  analogWrite(11, speed);
}

void left_motor_a_ccw(int speed) {
  digitalWrite(3, HIGH);
  digitalWrite(15, LOW);
  analogWrite(11, speed);
}


void left_motor_b_cw(int speed) {
  digitalWrite(2, HIGH);
  digitalWrite(7, LOW);
  analogWrite(6, speed);
}

void left_motor_b_ccw(int speed) {
  digitalWrite(7, HIGH);
  digitalWrite(2, LOW);
  analogWrite(6, speed);
}

void right_motor_a_cw(int speed) {
  digitalWrite(5, HIGH);
  digitalWrite(8, LOW);
  analogWrite(10, speed);
}

void right_motor_a_ccw(int speed) {
  digitalWrite(8, HIGH);
  digitalWrite(5, LOW);
  analogWrite(10, speed);
}

void right_motor_b_cw(int speed) {
  digitalWrite(4, HIGH);
  digitalWrite(14, LOW);
  analogWrite(9, speed);
}

void right_motor_b_ccw(int speed) {
  digitalWrite(14, HIGH);
  digitalWrite(4, LOW);
  analogWrite(9, speed);
}

void stop_all_motors() {
  // L: 2,3,4,5,6,8,9,15
  // H: 7,10,11,14
  digitalWrite(2, LOW);
  digitalWrite(3, LOW);
  digitalWrite(4, LOW);
  digitalWrite(5, LOW);
  digitalWrite(7, LOW);
  digitalWrite(8, LOW);
  digitalWrite(14, LOW);
  digitalWrite(15, LOW);

  digitalWrite(6, HIGH);
  digitalWrite(10, HIGH);
  digitalWrite(11, HIGH);
  digitalWrite(9, HIGH);
}


  /*
  //verzia testu 1

  left_motor_a_cw();
  left_motor_b_cw();
  right_motor_a_cw();
  right_motor_b_cw();
  delay(2500);
  stop_all_motors();
  delay(2500);
 
  left_motor_a_ccw(255);
  left_motor_b_ccw();
  right_motor_a_ccw();
  right_motor_b_ccw();
  delay(2500);
stop_all_motors();
  delay(2500);
 
  left_motor_a_cw();
  left_motor_b_cw();
  right_motor_a_ccw();
  right_motor_b_ccw();
  delay(2500);
stop_all_motors();
  delay(2500);
 
  left_motor_a_ccw(255);
  left_motor_b_ccw();
  right_motor_a_cw();
  right_motor_b_cw();
  delay(2500);
stop_all_motors();
  delay(2500);
 
  left_motor_a_ccw(255);
  left_motor_b_ccw();
  right_motor_a_ccw();
  right_motor_b_cw();
  delay(2500);
*/

// 0  toc vlavo
// 3  dopredu
// 6  vlavo
// 9  vpravo
// 12  dozadu
// 15  toc vpravo

void otocka_vlavo(int speed)
{
    left_motor_a_ccw(speed);
    left_motor_b_ccw(speed);
    right_motor_a_ccw(speed);
    right_motor_b_ccw(speed);
}

void otocka_vpravo(int speed)
{
    left_motor_a_cw(speed);
    left_motor_b_cw(speed);
    right_motor_a_cw(speed);
    right_motor_b_cw(speed);
}


void sikmo_vpravo(int speed1, int speed2)
{
    left_motor_a_cw(speed1);
    left_motor_b_ccw(speed2);
    right_motor_a_ccw(speed1);
    right_motor_b_cw(speed2);
}

void vzad(int speed)
{
    left_motor_a_ccw(speed);
    left_motor_b_ccw(speed);
    right_motor_a_cw(speed);
    right_motor_b_cw(speed);
}

void vpred(int speed)
{
    left_motor_a_cw(speed);
    left_motor_b_cw(speed);
    right_motor_a_ccw(speed);
    right_motor_b_ccw(speed);
}

void vpravo(int speed)
{
      left_motor_a_ccw(speed);
    left_motor_b_cw(speed);
    right_motor_a_cw(speed);
    right_motor_b_ccw(speed);
}

void vlavo(int speed)
{
    left_motor_a_cw(speed);
    left_motor_b_ccw(speed);
    right_motor_a_ccw(speed);
    right_motor_b_cw(speed);
}

void loop() {


  //experiment 1

  sikmo_vpravo(255, 110);
  delay(3000);
  stop_all_motors();
  delay(1000);

  return;

  for (int s = 127; s < 256; s += 32)
  {
  //vzad
    vzad(s);
    delay(1000);
    stop_all_motors();
    delay(1000);

  //vpred
    vpred(s);
    delay(1000);
    stop_all_motors();
    delay(1000);

  //otocka vlavo
    otocka_vlavo(s);
    delay(1000);
    stop_all_motors();
    delay(1000);

  //otocka vpravo
    otocka_vpravo(s);
    delay(1000);
    stop_all_motors();
    delay(1000);

  //vlavo
    vlavo(s);
    delay(1000);
    stop_all_motors();
    delay(1000);

  //vpravo
    vpravo(s);
    delay(1000);
    stop_all_motors();
    delay(1000);
  }
}


/*


//verzia testu 2

  for (int i = 0; i < 16; i++) {
    if (i & 1) left_motor_a_cw();
    else left_motor_a_ccw(255);
    if (i & 2) left_motor_b_cw();
    else left_motor_b_ccw();
    if (i & 4) right_motor_a_cw();
    else right_motor_a_ccw();
    if (i & 8) right_motor_b_cw();
    else right_motor_b_ccw();
    delay(2500);
    stop_all_motors();
    delay(2500);


  }


  stop_all_motors();
  delay(5000);
}

*/
